% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{fast_discretization}
\alias{fast_discretization}
\title{Discretization}
\usage{
fast_discretization(data_set, bins = NULL, verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{bins}{Result of function \code{\link{build_bins}}, (list, default to NULL). \cr
To perform the same discretization on train and test, it is recommended to compute \code{\link{build_bins}}
before. If it is kept to NULL, build_bins will be called.\cr
\code{bins} could also be carefully hand written.}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
Same dataset discretized by \strong{reference}. \cr
If you don't want to edit by reference please provide set \code{data_set = copy(data_set)}.
}
\description{
Discretization of numeric variable (either equal_width or equal_fred).
}
\details{
NAs will be putted in an NA category.
}
\examples{
# Load data
data(tiny_messy_adult)
head(tiny_messy_adult)

# Compute bins
bins <- build_bins(tiny_messy_adult, cols = "auto", n_bins = 5, type = "equal_freq")

# Discretize
tiny_messy_adult <- fast_discretization(tiny_messy_adult, bins = bins)

# Control
head(tiny_messy_adult)

# Example with hand written bins
data("adult")
adult <-  fast_discretization(adult, bins = list(age = c(0, 40, +Inf)))
print(table(adult$age))
}
