% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_imputation_simple.R
\name{imputation_simple}
\alias{imputation_simple}
\title{Simple imputation}
\usage{
imputation_simple(method = c("median", "mean"), cols = NULL)
}
\arguments{
\item{method}{imputation method: "median" or "mean"}

\item{cols}{optional vector of column names to impute (default: all numeric columns)}
}
\value{
returns an object of class \code{imputation_simple}
}
\description{
Impute missing values in numeric columns using the mean or median.
}
\examples{
data(iris)
iris_na <- iris
iris_na$Sepal.Length[c(2, 10, 25)] <- NA

imp <- imputation_simple(method = "median")
imp <- fit(imp, iris_na)
iris_imp <- transform(imp, iris_na)
summary(iris_imp$Sepal.Length)
}
