% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_xgboost.R
\name{cla_xgboost}
\alias{cla_xgboost}
\title{XGBoost}
\usage{
cla_xgboost(attribute, params = list(), nrounds = 20)
}
\arguments{
\item{attribute}{target attribute name}

\item{params}{list of xgboost parameters}

\item{nrounds}{number of boosting rounds}
}
\value{
returns a \code{cla_xgboost} object
}
\description{
Gradient boosting classifier using \code{xgboost}.
}
\examples{
if (requireNamespace("xgboost", quietly = TRUE)) {
 data(iris)
 model <- cla_xgboost("Species", nrounds = 20)
 model <- fit(model, iris)
 pred <- predict(model, iris)
 table(pred, iris$Species)
}
}
