% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_form_data_attachment.R
\name{cto_form_data_attachment}
\alias{cto_form_data_attachment}
\title{Download Attachments from SurveyCTO Form Data}
\usage{
cto_form_data_attachment(
  form_id,
  fields = everything(),
  private_key = NULL,
  dir = file.path(getwd(), "media"),
  overwrite = FALSE
)
}
\arguments{
\item{form_id}{A string specifying the SurveyCTO form ID to inspect.}

\item{fields}{A \code{tidy-select} expression (e.g., \code{everything()}, \code{starts_with("img_")})
specifying which columns should be scanned for attachment URLs. Defaults to \code{everything()}.}

\item{private_key}{Optional. A character string specifying the path to a local
RSA private key file. Required if the form is encrypted.}

\item{dir}{A character string specifying the local directory where files should be saved.
Defaults to \code{"media"}. The directory must exist.}

\item{overwrite}{Logical. If \code{TRUE}, existing files with the same name in \code{dir}
will be overwritten. If \code{FALSE} (the default), existing files are skipped.}
}
\value{
Returns a vector of file paths (invisibly). The function is called for its side effect
of downloading files to the local disk.
}
\description{
Extracts attachment URLs (images, audio, video, signatures) from SurveyCTO form data
and downloads the files to a local directory. This function handles encrypted forms
if a private key is provided.
}
\details{
This function performs the following steps:
\enumerate{
\item Fetches the form data using \code{cto_form_data}.
\item Scans the selected \code{fields} for values matching the standard SurveyCTO API
attachment URL pattern.
\item Downloads the identified files sequentially to the specified \code{dir}.
}
}
\examples{
\dontrun{
# 1. Download all attachments from the form submissions
cto_form_data_attachment(
  form_id = "household_survey_v1",
  dir = "downloads/medias"
)

# 2. Download only specific image fields from an encrypted form
cto_form_data_attachment(
  form_id = "encrypted_health_survey",
  fields = starts_with("image_"),
  private_key = "keys/my_priv_key.pem",
  overwrite = TRUE
)
}
}
\seealso{
Other Form Management Functions: 
\code{\link{cto_form_attachment}()},
\code{\link{cto_form_data}()},
\code{\link{cto_form_dofile}()},
\code{\link{cto_form_languages}()},
\code{\link{cto_form_metadata}()}
}
\concept{Form Management Functions}
