% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{rlmap}
\alias{rlmap}
\title{Recursive lmap}
\usage{
rlmap(.x, .f, ...)
}
\arguments{
\item{.x}{a list}

\item{.f}{a function (called with elements of \code{.x} as the first argument)}

\item{...}{further arguments passed to the function \code{.f}}
}
\value{
A list
}
\description{
Applies function \code{.f} to each list-element in \code{.x} as per \code{purrr::lmap}.
If the value of the list-element is itself a list, then the function is applied to that in turn.
The process is followed recursively until an atomic value at the leaf nodes of the list is found.
If \code{.f} modifies the name, it is thrown away and replaced by the original name.
}
\keyword{internal}
