% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_covr.R
\name{h_covr_helpers}
\alias{h_covr_helpers}
\alias{h_covr_active}
\alias{h_covr_detrace}
\alias{h_is_covr_trace}
\alias{h_covr_detrace_call}
\title{Helpers for stripping expressions of \code{covr}-inserted trace code}
\usage{
h_covr_active()

h_covr_detrace(expr)

h_is_covr_trace(expr)

h_covr_detrace_call(expr)
}
\arguments{
\item{expr}{(\code{language})\cr an R expression or call to test or strip of
\code{covr} trace counters.}
}
\value{
A logical value or transformed expression with calls to
\code{covr:::count} removed.
}
\description{
Workarounds to allow the package to continue to work while running \code{covr}
with minimal changes to the package code.
}
\details{
When using \code{covr}, the source code for package objects are modified to add
callbacks for each expression to log its execution. Given an arbitrary
expression, such as:

\if{html}{\out{<div class="sourceCode">}}\preformatted{expr
}\if{html}{\out{</div>}}

The code will be modified before executing any package code to look like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{if (TRUE) \{
  covr:::count("file.R:1:2:3:4:5:6:7:8")
  expr
\}
}\if{html}{\out{</div>}}

These functions are used for stripping expressions of this code so that the
package continues to work as intended while running tests as part of running
\code{covr} to calculate package coverage.

This method is non-exhaustive, covering only a subset of \code{covr}'s tracing
behaviors necessary for this package.
}
\section{Functions}{
\itemize{
\item \code{h_covr_active()}: Determine whether \code{covr} is currently running

\item \code{h_covr_detrace()}: Remove \code{covr} traces from an expression

\item \code{h_is_covr_trace()}: Determine whether the current expression is a \code{covr}-modified expression

\item \code{h_covr_detrace_call()}: Extract the original expression from a \code{covr}-modified expression

}}
\keyword{internal}
