% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{OpeningList-class}
\alias{OpeningList-class}
\alias{.OpeningList}
\alias{OpeningList}
\alias{.DefaultOpeningList}
\title{\code{OpeningList}}
\usage{
OpeningList(...)

.DefaultOpeningList()
}
\arguments{
\item{...}{(\code{Opening})\cr opening objects to combine.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{OpeningList}} is a virtual class for combining multiple \code{\link{Opening}} objects
using logical operators. It is used as a base class for \code{\link{OpeningAll}} and
\code{\link{OpeningAny}}.
}
\section{Slots}{

\describe{
\item{\code{open_list}}{(\code{list})
a list of \code{\link{Opening}} objects to be combined.}
}}

\note{
Typically, end users will not use the \code{.DefaultOpeningList()} function.
}
\examples{
# Create two simple opening criteria
opening1 <- OpeningMinDose(min_dose = 10)
opening2 <- OpeningMinCohorts(min_cohorts = 3)

# Create an OpeningList that combines them
opening_list <- OpeningList(opening1, opening2)
print(opening_list)

# You can also create with more than two criteria
opening3 <- OpeningNone()
opening_list_multi <- OpeningList(opening1, opening2, opening3)
print(opening_list_multi)
}
\seealso{
\code{\link{Opening}}, \code{\link{OpeningAll}}, \code{\link{OpeningAny}}.
}
