% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{check_equal}
\alias{check_equal}
\alias{assert_equal}
\title{Check if All Arguments Are Equal}
\usage{
check_equal(..., tol = sqrt(.Machine$double.eps))

assert_equal(
  ...,
  tol = sqrt(.Machine$double.eps),
  .var.name = vname(x),
  add = NULL
)
}
\arguments{
\item{...}{(\code{numeric})\cr vectors to be compared}

\item{tol}{(\code{numeric})\cr the maximum difference to be tolerated when
judging equality}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
\code{TRUE} if all element-by-element differences are less than \code{tolerance}
in magnitude, \code{FALSE} otherwise.

\code{list(...)}, invisibly.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Elements of \code{...} must be numeric vectors or scalars.

This function performs an element-by-element comparison of the first object
provided in \code{...} with every other object in \code{...} and returns \code{TRUE} if all
comparisons are equal within a given tolerance and \code{FALSE} otherwise.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Elements of \code{...} must be numeric vectors or scalars.

This function performs an element-by-element comparison of the first object
provided in \code{...} with every other object in \code{...} and throws an error if they
are not.
}
\note{
If there are any missing or infinite values in \code{...}, this function
returns \code{FALSE}, regardless of the values of other elements in \code{...}.

If elements in \code{...} are not all of the same length, \code{FALSE} is returned.

If there are any missing or infinite values in \code{...}, this function
throws an error, regardless of the values of other elements in \code{...}.

If elements in \code{...} are not all of the same length, an error is thrown.
}
\examples{
check_equal(1:2, 1:2) # TRUE
check_equal(1:2, 2:3) # "Not all equal"
check_equal(Inf, Inf) # "Not all equal"
check_equal(0.01, 0.02) # "Not all equal"
check_equal(0.01, 0.02, tol = 0.05) # TRUE
check_equal(1, c(1, 1)) # "Not all equal"
assert_equal(1:2, 1:2) # no error
assert_equal(0.01, 0.02, tol = 0.05) # no error
}
\seealso{
\code{\link{assertions}} for more details.

\code{\link{assertions}} for more details.
}
