% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{OneParExpPrior-class}
\alias{OneParExpPrior-class}
\alias{.OneParExpPrior}
\alias{OneParExpPrior}
\alias{.DefaultOneParExpPrior}
\title{\code{OneParExpPrior}}
\usage{
OneParExpPrior(skel_probs, dose_grid, lambda)

.DefaultOneParExpPrior()
}
\arguments{
\item{skel_probs}{see slot definition.}

\item{dose_grid}{(\code{numeric})\cr dose grid. It must be must be a sorted vector
of the same length as \code{skel_probs}.}

\item{lambda}{see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{OneParExpPrior}} is the class for a standard CRM with an exponential prior
on the power parameter for the skeleton prior probabilities. It is an
implementation of a version of the one-parameter CRM
\insertCite{OQuigleyPepeFisher1990}{crmPack}.
}
\section{Slots}{

\describe{
\item{\code{skel_fun}}{(\code{function})\cr function to calculate the prior DLT probabilities.}

\item{\code{skel_fun_inv}}{(\code{function})\cr inverse function of \code{skel_fun}.}

\item{\code{skel_probs}}{(\code{numeric})\cr skeleton prior probabilities. This is a vector
of unique and sorted probability values between 0 and 1.}

\item{\code{lambda}}{(\code{number})\cr rate parameter of prior exponential distribution
for theta.}
}}

\note{
Typically, end users will not use the \code{.DefaultOneparExpPrior()} function.

Typically, end users will not use the \code{.DefaultOneParLogNormalPrior()} function.
}
\examples{
my_model <- OneParExpPrior(
  skel_probs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  dose_grid = 1:5,
  lambda = 2
)
}
\references{
\insertAllCited{}
}
