% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{interval_gRcpp}
\alias{interval_gRcpp}
\title{Estimate confidence intervals/bands for a STAR process}
\usage{
interval_gRcpp(g_a_j, g_a_jp1, L_mu, U_mu, sigma, Jmax)
}
\arguments{
\item{g_a_j}{\code{Jmax x 1} vector of g(a(j))}

\item{g_a_jp1}{\code{Jmax x 1} vector of g(a(j + 1))}

\item{L_mu}{\code{m x 1} vector of lower intervals for \code{mu}}

\item{U_mu}{\code{m x 1} vector of upper intervals for \code{mu}}

\item{sigma}{\code{m x 1} vector of conditional standard deviations}

\item{Jmax}{\code{m x 1} vector of maximum integer values to consider}
}
\value{
LU_y \code{m x 2} vector of intervals for \code{y}.
}
\description{
Compute confidence intervals/bands for the expected value of the count-valued STAR process \code{y}
based on intervals/bands for the Gaussian process \code{mu}.
}
\note{
This function uses \code{Rcpp} for computational efficiency.
}
\keyword{internal}
