% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zpk.R
\name{zpk}
\alias{zpk}
\title{Create Zero-Pole-Gain Model.}
\usage{
zpk(zero, pole, gain, Ts = NULL)
}
\arguments{
\item{zero}{A vector}

\item{pole}{A vector}

\item{gain}{A vector}

\item{Ts}{Sample time for discrete time systems}
}
\value{
Returns a list object of 'zpk' class.
}
\description{
\code{zpk} creates the model for a system represented in zero-pole form
}
\details{
\code{zpk} creates a model object for zero-pole systems.
}
\examples{
sys <- zpk(NULL, c(-1,-1), 1)
sys <- zpk(c(1,2), c(3,4), 5)
sys <- zpk(c(1,2), c(3+1i,4+2i), 5)

\dontrun{  Access individual sys elements as }
sys$z
sys$p
sys$k

}
\seealso{
\code{\link{ss}} \code{\link{tf}}
}
