% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss2tf.R
\name{ss2tf}
\alias{ss2tf}
\title{State-space model conversion to Transfer function model.}
\usage{
ss2tf(a, b, c, d, iu)
}
\arguments{
\item{a}{An n x n matrix}

\item{b}{An n x m matrix}

\item{c}{An p x n matrix}

\item{d}{An p x m matrix}

\item{iu}{A numeric value denoting number of inputs. default value is 1.For example, if the system
has three inputs (u1, u2, u3), then iu must be either 1, 2, or 3, where 1 implies u1, 2
implies u2, and 3 implies u3.}
}
\value{
Returns an object of 'tf' class containing \code{num} and \code{den}. The numerator coefficients
are returned in matrix \code{num} with as many rows as outputs \code{y}.
}
\description{
\code{ss2tf} converts the model for a state-space system to transfer function representation
}
\details{
\code{ss2tf} converts a model object in state-space form to transfer function model by calculating the transfer function of the system:
.
x = Ax + Bu
y = Cx + Du

#' Other possible usages for \code{ss2tf} are:
\code{ss2tf(a,b,c,d)}
\code{ss2tf(sys)}
\code{ss2tf(sys, iu)}

where \code{sys} is an object of state-space class
}
\examples{
sys2 <- tf2ss(tf(1, c(1,2,1)))
ss2tf(sys2)

\dontrun{  OR }

ss2tf(sys2$A,sys2$B,sys2$C,sys2$D)

# a single input multiple output system
A <- rbind(c(0,1), c(-10000,-4)); B <- rbind(0,1); C <- rbind(c(1,0), c(0,1));
D <- rbind(0,0)
ss2tf(A, B, C, D)

# a MIMO system
A = rbind(c(0,1), c(-25,-4)); B = rbind(c(1,1), c(0,1));
C = rbind(c(1,0), c(0,1)); D = rbind(c(0,0), c(0,0))
ss2tf(A,B,C,D,1) # to obtain output for input 1
ss2tf(A,B,C,D,2) # to obtain output for input 2

## OR

systems <- vector("list", ncol(D))
for(i in 1:ncol(D)){ systems[[i]] <- ss2tf(A,B,C,D,i) }
systems
systems[[1]]
systems[[2]]

}
\seealso{
\code{\link{tf2ss}} \code{\link{ss2zp}}
}
