% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss.R
\name{ss}
\alias{ss}
\title{Create State-space Model.}
\usage{
ss(A, B, C, D, Ts = NULL)
}
\arguments{
\item{A}{An n x n matrix}

\item{B}{An n x m matrix}

\item{C}{An p x n matrix}

\item{D}{An p x m matrix}

\item{Ts}{Sample time for discrete time systems}
}
\value{
Returns a list object of 'ss' class.
}
\description{
\code{ss} creates the model for a system represented in state-space form
}
\details{
\code{ss} creates a model object for state-space systems.
}
\examples{
A <- rbind(c(-2, -1), c(1,0))
B <- rbind(1,0)
C <- cbind(0,1)
D <- 0;
sys <- ss(A,B,C,D)

\dontrun{  OR }

sys <- ss(c(-2,-1,1,0), c(1,0), c(0,1), 0)

\dontrun{  Access individual state-space sys elements as }

sys$A
sys$B
sys$C
sys$D

}
\seealso{
\code{\link{tf}} \code{\link{zpk}}
}
