% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fun.R
\name{plot_fun}
\alias{plot_fun}
\title{Plot Functional Split Conformal Confidence Bands}
\usage{
plot_fun(
  out,
  y0 = NULL,
  ylab = NULL,
  titles = NULL,
  date = NULL,
  ylim = NULL,
  fillc = "red"
)
}
\arguments{
\item{out}{The output of the split/msplit/jackknife+ function.}

\item{y0}{The true values at x0.}

\item{ylab}{The label for the y-axes.}

\item{titles}{The title for the plot.}

\item{date}{A vector of dates.}

\item{ylim}{A vector containing the extremes for the y-axes.}

\item{fillc}{A string of color.}
}
\value{
None
}
\description{
The function plots the confidence bands provided by the \code{\link{conformal.fun.split}} #'function, \code{\link{conformal.fun.msplit}} and \code{\link{conformal.fun.jackplus}}.
}
\details{
It exploits the package \code{\link[ggplot2]{ggplot}},
\code{\link[ggpubr]{ggarrange}} and \code{\link[ggpubr]{annotate_figure}}.
to better visualize the results. It outputs n0=length(x0) plots.

It plots, for each value in x0, the predicted functional
value and bands in all the
dimensions of the multivariate functional response.
}
