% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_rows.R
\name{show_rows}
\alias{show_rows}
\title{Selects the rows to be printed}
\usage{
show_rows(x, ...)
}
\arguments{
\item{x}{condformat_tbl object}

\item{...}{Expressions used for filtering}
}
\value{
A condformat_show_rows object, usually to be added to a condformat_tbl object
as shown in the examples
}
\description{
Keeps the rows you mention in the printed table.
Compared to \code{\link[dplyr:filter]{dplyr::filter()}}, show_rows does not remove the
rows from the actual data frame, they are removed only for printing.
}
\examples{
library(condformat)
data(iris)
x <- head(iris)
cf <- condformat(x) \%>\% show_rows(Sepal.Length > 4.5, Species == "setosa")
\dontrun{
print(cf)
}
# Use it programatically
expr_as_text <- 'Sepal.Length > 4.5'
expr <- rlang::parse_expr(expr_as_text)
cf <- condformat(x) \%>\% show_rows(!! expr)
\dontrun{
print(cf)
}
# With multiple arguments:
expr_as_text <- c('Sepal.Length > 4.5', 'Species == "setosa"')
exprs <- lapply(expr_as_text, rlang::parse_expr)
cf <- condformat(x) \%>\% show_rows(!!! exprs)
\dontrun{
print(cf)
}
}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}}
}
