% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{is_converged}
\alias{is_converged}
\title{Check if solver converged}
\usage{
is_converged(x, ...)
}
\arguments{
\item{x}{An mle result object}

\item{...}{Additional arguments (unused)}
}
\value{
Logical indicating convergence
}
\description{
Check if solver converged
}
\examples{
\donttest{
problem <- mle_problem(
  loglike = function(theta) -sum((theta - c(1, 2))^2)
)
result <- gradient_ascent(max_iter = 50)(problem, c(0, 0))
is_converged(result)
}
}
