% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcTPRTSV.r
\name{calcTPRTSV}
\alias{calcTPRTSV}
\alias{TPR}
\alias{tpr}
\title{True Positive Rate between Predicted and Actual Thermal Sensation Vote}
\usage{
calcTPRTSV(ref, pred)
}
\arguments{
\item{ref}{a numeric item or vector containing categorical actual thermal 
sensation votes coded from -3 'cold' to +3 'hot'}

\item{pred}{a numeric item or vector containing categorical predicted thermal 
sensation votes coded from -3 'cold' to +3 'hot'}
}
\value{
\code{calcTPRTSV} returns a single value presenting the true positive 
rate between actual and predicted thermal sensation votes.
}
\description{
\code{calcTPRTSV} calculates the true positive rate between 
predicted thermal sensation votes and actual obtained sensation votes
}
\examples{
## Define data
ref <- rnorm(5) # actual thermal sensation votes
ref <- cutTSV(ref)
pred <- rnorm(5) # predicted thermal sensation votes
pred <- cutTSV(pred)
calcTPRTSV(ref, pred)

}
\references{
Schweiker & Wagner (2015) <doi:10.1016/j.buildenv.2015.08.018>
}
\seealso{
see also \code{\link{calcMeanBias}}, \code{\link{calcAvgAcc}}
}
\author{
Marcel Schweiker
}
\keyword{manip}
