% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-nih-enrollment.R
\name{table_nih_enrollment}
\alias{table_nih_enrollment}
\alias{table_nih_enrollment_pretty}
\title{Produce an NIH-compliant enrollment table.}
\usage{
table_nih_enrollment(
  d,
  d_lu_gender = NULL,
  d_lu_race = NULL,
  d_lu_ethnicity = NULL,
  variable_gender = "gender",
  variable_race = "race",
  variable_ethnicity = "ethnicity"
)
}
\arguments{
\item{d}{\link{data.frame} of observed values in the investigation. Required.}

\item{d_lu_gender}{\link{data.frame} that maps the observed levels of gender to the NIH-recommended levels of gender. Required only if the levels are not the same.}

\item{d_lu_race}{\link{data.frame} that maps the observed levels of gender to the NIH-recommended levels of gender. Required only if the levels are not the same.}

\item{d_lu_ethnicity}{\link{data.frame} that maps the observed levels of gender to the NIH-recommended levels of gender. Required only if the levels are not the same.}

\item{variable_gender}{name of the gender variable in the \code{d} \link{data.frame}.  Defaults to gender.}

\item{variable_race}{name of the race variable in the \code{d} \link{data.frame}.  Defaults to race.}

\item{variable_ethnicity}{name of the ethnicity variable in the \code{d} \link{data.frame}.  Defaults to ethnicity.}
}
\value{
Table for publication
}
\description{
Produce an NIH enrollment table, leveraging metadata to adapt to the observed \link{data.frame}.
}
\details{
https://grants.nih.gov/grants/how-to-apply-application-guide/forms-d/general/g.500-phs-inclusion-enrollment-report.htm
}
\examples{
ds_1 <- tibble::tribble(
  ~subject_id,   ~gender  , ~race                      ,   ~ethnicity                     ,
           1L,   "Male"   , "Black or African American",  "Not Hispanic or Latino"        ,
           2L,   "Male"   , "Black or African American",  "Not Hispanic or Latino"        ,
           3L,   "Female" , "Black or African American",  "Unknown/Not Reported Ethnicity",
           4L,   "Male"   , "White"                    ,  "Not Hispanic or Latino"        ,
           5L,   "Male"   , "White"                    ,  "Not Hispanic or Latino"        ,
           6L,   "Female" , "White"                    ,  "Not Hispanic or Latino"        ,
           7L,   "Male"   , "White"                    ,  "Hispanic or Latino"            ,
           8L,   "Male"   , "White"                    ,  "Hispanic or Latino"
)

table_nih_enrollment(ds_1)
table_nih_enrollment_pretty(ds_1)

table_nih_enrollment(ds_1) |>
  tidyr::pivot_wider(names_from = gender, values_from = n)

table_nih_enrollment(ds_1) |>
  dplyr::mutate(
    gender_ethnicity = paste0(gender, " by ", ethnicity)
  ) |>
  dplyr::select(-gender, -ethnicity) |>
  tidyr::pivot_wider(names_from = gender_ethnicity, values_from = n)

ds_2 <- tibble::tribble(
  ~subject_id,  ~gender , ~race                      , ~ethnicity    ,
           1L,  "Male"  , "Black or African American", "Not Latino"  ,
           2L,  "Male"  , "Black or African American", "Not Latino"  ,
           3L,  "Female", "Black or African American", "Unknown"     ,
           4L,  "Male"  , "White"                    , "Not Latino"  ,
           5L,  "Male"  , "White"                    , "Not Latino"  ,
           6L,  "Female", "White"                    , "Not Latino"  ,
           7L,  "Male"  , "White"                    , "Latino"      ,
           8L,  "Male"  , "White"                    , "Latino"
)

ds_lu_ethnicity <- tibble::tribble(
  ~input      ,   ~displayed                      ,
  "Not Latino",  "Not Hispanic or Latino"         ,
  "Latino"    ,  "Hispanic or Latino"             ,
  "Unknown"   ,  "Unknown/Not Reported Ethnicity"
)
table_nih_enrollment(ds_2, d_lu_ethnicity = ds_lu_ethnicity)
table_nih_enrollment_pretty(ds_2, d_lu_ethnicity = ds_lu_ethnicity)

## Read a 500-patient fake dataset
path <- system.file("misc/example-data-1.csv", package = "codified")
ds_3 <- readr::read_csv(path) |>
  dplyr::mutate(
    gender     = as.character(gender),
    race       = as.character(race),
    ethnicity  = as.character(ethnicity)
  )

ds_lu_gender <- tibble::tribble(
  ~input,   ~displayed                      ,
  "0"   ,  "Female",
  "1"   ,  "Male",
  "U"   ,  "Unknown/Not Reported"
)
ds_lu_race <- tibble::tribble(
  ~input ,   ~displayed                      ,
  "1"    , "American Indian/Alaska Native",
  "2"    , "Asian",
  "3"    , "Native Hawaiian or Other Pacific Islander",
  "4"    , "Black or African American",
  "5"    , "White",
  "M"    , "More than One Race",
  "6"    , "Unknown or Not Reported"
)
ds_lu_ethnicity <- tibble::tribble(
  ~input,   ~displayed                      ,
  "2"   ,  "Not Hispanic or Latino"         ,
  "1"   ,  "Hispanic or Latino"             ,
  "0"   ,  "Unknown/Not Reported Ethnicity"
)

table_nih_enrollment(
  d              = ds_3,
  d_lu_gender    = ds_lu_gender,
  d_lu_race      = ds_lu_race,
  d_lu_ethnicity = ds_lu_ethnicity
)

table_nih_enrollment_pretty(
  d              = ds_3,
  d_lu_gender    = ds_lu_gender,
  d_lu_race      = ds_lu_race,
  d_lu_ethnicity = ds_lu_ethnicity
)
}
\author{
Will Beasley, Peter Higgins, Andrew Peters, Sreeharsha Mandem
}
