% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_codemeta.R
\name{create_codemeta}
\alias{create_codemeta}
\title{create_codemeta}
\usage{
create_codemeta(
  pkg = ".",
  root = ".",
  id = NULL,
  use_filesize = FALSE,
  force_update = getOption("codemeta_force_update", TRUE),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{pkg}{package path to package root, or description file
(character), or a codemeta object (list)}

\item{root}{if pkg is a codemeta object, optionally give the path to package
root. Default guess is current dir.}

\item{id}{identifier for the package, e.g. a DOI (or other resolvable URL)}

\item{use_filesize}{whether to try to estimating and adding a filesize by using
\code{base::file.size()}. Files in \code{.Rbuildignore} are ignored.}

\item{force_update}{Update guessed fields even if they are defined in an
existing codemeta.json file}

\item{verbose}{Whether to print messages indicating opinions e.g. when
DESCRIPTION has no URL. -- See \code{\link{give_opinions}};
and indicating the progress of internet downloads.}

\item{...}{additional arguments to \code{\link[jsonlite]{write_json}}}
}
\value{
a codemeta list object
}
\description{
create a codemeta list object in R for further manipulation. Similar
to \code{\link[=write_codemeta]{write_codemeta()}}, but returns an R list object rather
than writing directly to a file.  See examples.
}
\examples{
\donttest{
path <- system.file("", package="codemeta")
cm <- create_codemeta(path)
cm$keywords <- list("metadata", "ropensci")
}
}
