% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_helpers.R
\name{likert_from_items}
\alias{likert_from_items}
\title{Derive a likert object from items}
\usage{
likert_from_items(items)
}
\arguments{
\item{items}{a data frame of items composing one scale}
}
\description{
Pass a data.frame containing several items composing one scale, get a
\code{\link[likert:likert]{likert::likert()}} object, which you can plot.
Intelligently makes use of labels and value labels if present.
}
\examples{
data("bfi", package = "codebook")
open_items <- paste0("BFIK_open_",1:4)
suppressWarnings(graphics::plot(likert_from_items(bfi[, open_items])))
}
