% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTrees.R
\name{simUltra}
\alias{simUltra}
\title{Simulate ultrametric birth and death branching trees}
\usage{
simUltra(
  a,
  b,
  cloneAge,
  n,
  nTrees = 1,
  precBits = 1000,
  addStem = FALSE,
  nCores = 1
)
}
\arguments{
\item{a}{Birth rate or vector of birth rates of length 'nTrees'}

\item{b}{Death rate or vector of death rates of length 'nTrees'}

\item{cloneAge}{Clone age or vector of clone ages of length 'nTrees'. Make
sure it's same time units as birth and death rates}

\item{n}{Number of samples/tips of the tree to be returned. Can be a vector
of length 'nTrees' as well.}

\item{nTrees}{Integer indicating the number of trees to generate. Default is
1}

\item{precBits}{Rmpfr param for handling high precision numbers. Needed for
drawing the coalescence times. Can be a vector of length 'nTrees', though
it is not recommended}

\item{addStem}{Boolean indicating whether to add stem to tree preceding first
split/coalescence. Can also be a vector of length 'nTrees'}

\item{nCores}{Integer indicating the number of cores to use if parallel pkg
is installed. Default is 1.}
}
\value{
An ape object of class "phylo" representing the ultrametric
phylogenetic tree with edge lengths in units of time. Tree metadata is
located in the 'metadata' data.frame included in each "phylo" object. If
'nTrees' param is greater than 1, simUltra returns a list of objects of
such objects of class "phylo".
}
\description{
Generates a sampled tree (or a list of many sampled trees) from
a supercritial (birth rate > death rate) birth and death branching process
according to the coalescent point process described in "Lambert, A. The
coalescent of a sample from a binary branching process. (2018)."
}
\examples{
# Generate a single tree
tree <- simUltra(a = 1, b = 0.5, cloneAge = 20, n = 50)

# Generate a list of trees
tree_list <- simUltra(a = 1, b = 0.5, cloneAge = 20, n = 50, nTrees = 3)

}
