% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_validate.R
\name{compare_observations_by_id}
\alias{compare_observations_by_id}
\title{Compare Observations by ID Variables}
\usage{
compare_observations_by_id(df1, df2, id_vars, common_cols, tolerance = 0)
}
\arguments{
\item{df1}{First data frame (base).}

\item{df2}{Second data frame (compare).}

\item{id_vars}{Character vector of ID column names.}

\item{common_cols}{Character vector of common column names.}

\item{tolerance}{Numeric tolerance value for floating-point comparisons (default 0).
When tolerance > 0, numeric values are considered equal if their absolute
difference is within the tolerance threshold. Character and factor columns
always use exact matching regardless of tolerance.}
}
\value{
A list with:
\item{observation_comparison}{List with discrepancies and details (same
structure as \code{\link[=compare_observations]{compare_observations()}} output), plus id_details containing
the ID variable values for each difference}
\item{unmatched_rows}{List with df1_only and df2_only data frames}
}
\description{
Internal function to match rows between two datasets using specified key
variables, then compare values on matched rows. Also identifies unmatched
rows in either dataset.
}
\keyword{internal}
