% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh_marginalcontri.R
\name{ssh_marginalcontri}
\alias{ssh_marginalcontri}
\title{spatial association marginal contributions derived from spatial stratified heterogeneity}
\usage{
ssh_marginalcontri(formula, data, overlay = "and", cores = 1)
}
\arguments{
\item{formula}{A formula of ISP model.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{overlay}{(optional) Spatial overlay method. One of \code{and}, \code{or}, \code{intersection}.
Default is \code{and}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}
}
\value{
A list.
\describe{
\item{\code{pd}}{robust power of determinants}
\item{\code{spd}}{shap power of determinants}
\item{\code{determination}}{determination of the optimal interaction of variables}
}
}
\description{
spatial association marginal contributions derived from spatial stratified heterogeneity
}
\examples{
NTDs1 = sf::st_as_sf(gdverse::NTDs, coords = c('X','Y'))
g = ssh_marginalcontri(incidence ~ ., data = NTDs1, cores = 1)
g

}
