% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tiles.R
\name{get_tiles}
\alias{get_tiles}
\alias{read_tiles}
\title{Download imagery tiles}
\usage{
read_tiles(
  x,
  buffer,
  type = "mapbox.satellite",
  crop_to_buffer = TRUE,
  format = NULL,
  ...,
  zoom = NULL,
  debug = FALSE,
  max_tiles = NULL,
  base_url = NULL,
  verbose = TRUE,
  filename = ""
)

get_tiles(
  x,
  buffer,
  type = "mapbox.satellite",
  crop_to_buffer = TRUE,
  format = NULL,
  ...,
  zoom = NULL,
  debug = FALSE,
  max_tiles = NULL,
  base_url = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{a longitude, latitude pair of coordinates, or a spatial object}

\item{buffer}{width in metres to extend around the location, ignored if 'x' is a spatial object with extent}

\item{type}{character string of provider imagery type (see Details)}

\item{crop_to_buffer}{crop to the user extent, used for creation of output objects (otherwise is padded tile extent)}

\item{format}{tile format to use, defaults to "jpg" for Mapbox satellite imagery and "png" otherwise}

\item{...}{arguments passed to internal function, specifically \code{base_url} (see Details)}

\item{zoom}{desired zoom for tiles, use with caution - if \code{NULL} is chosen automatically}

\item{debug}{optionally avoid actual download, but print out what would be downloaded in non-debug mode}

\item{max_tiles}{maximum number of tiles - if \code{NULL} is set by zoom constraints}

\item{base_url}{tile provider URL expert use only}

\item{verbose}{report messages or suppress them}

\item{filename}{purely for \code{\link[=read_tiles]{read_tiles()}} this is passed down to the the terra package function 'merge'}
}
\value{
A list with files downloaded in character vector, a data frame of the tile indices,
the zoom level used and the extent in xmin,xmax,ymin,ymax form.
}
\description{
Obtain imagery or elevation tiles by location query. The first argument
\code{loc} may be a spatial object (sp, raster, sf) or a 2-column matrix with a single
longitude and latitude value. Use \code{buffer} to define a width and height to pad
around the raw longitude and latitude in metres. If \code{loc} has an extent, then
\code{buffer} is ignored.
}
\details{
\code{get_tiles()} may be run with no arguments, and will download (and report on) the default
tile source at zoom 0. Arguments \code{type}, \code{zoom} (or \code{max_tiles}), \code{format} may be used
without setting \code{loc} or \code{buffer} and the entire world extent will be used. Please use with caution!
There is no maximum on what will be downloaded, but it can be interrupted at any time.

Use \code{debug = TRUE} to avoid download and simply report on what would be done.

Available types are 'elevation-tiles-prod' for AWS elevation tiles, and 'mapbox.satellite',
'mapbox.terrain-rgb'.  (The RGB terrain values are not unpacked.)

Function \code{read_tiles()} will match what \code{get_tiles()} does and actually build a raster object.
}
\examples{
if (!is.null(get_api_key())) {
   tile_info <- get_tiles(ext(146, 147, -43, -42), type = "mapbox.satellite", zoom = 5)
}
}
\seealso{
get_tiles_zoom get_tiles_dim get_tiles_buffer
}
