% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry.R
\name{registry}
\alias{registry}
\alias{caugi_registry}
\alias{reset_caugi_registry}
\alias{seal_caugi_registry}
\title{\code{caugi} edge registry}
\usage{
caugi_registry()

reset_caugi_registry()

seal_caugi_registry()
}
\value{
An \code{edge_registry} external pointer.
}
\description{
The \code{caugi} edge registry stores information about the different edge types
that can be used in \code{caugi} graphs. It maps edge glyphs (e.g., \code{"-->"},
\code{"<->"}, \code{"o->"}, etc.) to their specifications, including tail and head
marks, class, and symmetry. The registry allows for dynamic registration of
new edge types, enabling users to extend the set of supported edges in
\code{caugi.} It is implemented as a singleton, ensuring that there is a single
global instance of the registry throughout the R session.
}
\details{
The intended use of the \code{caugi} registry is mostly for advanced users and
developers. The registry enables users who need to define their own custom
edge types in \code{caugi} directly. . It currently mostly supports the
\emph{representation} of new edges, but for users that might want to represent
reverse edges, this preserves correctness of reason over these edges.
}
\section{Functions}{
\itemize{
\item \code{caugi_registry()}: Access the global edge registry, creating it if needed.

\item \code{reset_caugi_registry()}: Reset the global edge registry to its default state.

\item \code{seal_caugi_registry()}: Seal the global edge registry to prevent further
modifications.

}}
\examples{
# first, for reproducability, we reset the registry to default
reset_caugi_registry()

# create a new registry
reg <- caugi_registry()

# register an edge
register_caugi_edge(
  glyph = "<--",
  tail_mark = "arrow",
  head_mark = "tail",
  class = "directed",
  symmetric = FALSE
)

# now, this edge is available for caugi graphs:
cg <- caugi(A \%-->\% B, B \%<--\% C, class = "DAG")

# reset the registry to default
reset_caugi_registry()

}
\seealso{
Other registry: 
\code{\link{register_caugi_edge}()}
}
\concept{registry}
