% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_mag}
\alias{is_mag}
\title{Is the \code{caugi} graph a MAG?}
\usage{
is_mag(cg, force_check = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{force_check}{Logical; if \code{TRUE}, the function will test if the graph is
a MAG, if \code{FALSE} (default), it will look at the graph class and match
it, if possible.}
}
\value{
A logical value indicating whether the graph is a MAG.
}
\description{
Checks if the given \code{caugi} graph is a
Maximal Ancestral Graph (MAG).

A MAG is an ancestral graph where no additional edge can be added without
violating the ancestral graph constraints or changing the encoded
independence model.
}
\examples{
cg_ag <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "AG"
)
is_mag(cg_ag) # TRUE (0 and 2 are m-separated by {B})

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
