% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtpareto}
\alias{dtpareto}
\alias{ptpareto}
\alias{qtpareto}
\alias{rtpareto}
\title{Density function of Truncated Pareto Distribution}
\usage{
dtpareto(x, xm, alpha, min = xm, max = 1e+09)

ptpareto(q, xm, alpha, min = xm, max = 1e+09)

qtpareto(p, xm, alpha, min = xm, max = 1e+09)

rtpareto(n, xm, alpha, min = xm, max = 1e+09)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{xm}{Threshold value}

\item{alpha}{Model parameter}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Pareto Distribution

Cumulative probability function of Truncated Pareto Distribution

Quantile function of Truncated Pareto Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Pareto Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtpareto(500,1000,2)
ptpareto(500,1000,2)
qtpareto(0.5,1000,2)
rtpareto(100,1000,2)
}
