% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_screening_reporting_analytics.R
\name{get_screening_reporting_analytics}
\alias{get_screening_reporting_analytics}
\title{Retrieves Reporting Metrics for Screening Tool}
\usage{
get_screening_reporting_analytics(
  start_date,
  end_date = NULL,
  level = c("country", "county", "subcounty", "ward", "facility"),
  organisations = NULL,
  ...
)
}
\arguments{
\item{start_date}{The start date to retrieve data. It is required and in the
format \code{YYYY-MM-dd}.}

\item{end_date}{The ending date for data retrieval (default is the current date).}

\item{level}{The desired data granularity: \code{"country"} (the default), \code{"county"},
\code{"subcounty"}, \code{"ward"}, or \code{"facility"}.}

\item{organisations}{A list of organization units ids to be filtered.}

\item{...}{Other options that can be passed onto KHIS API.}
}
\value{
A tibble with the reporting metrics.
}
\description{
\code{get_screening_reporting_analytics()} It fetches the reporting metrics for the
screening tool (MOH 745).
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Download screening metric from February 2023 to current date
data <- get_screening_reporting_analytics(start_date = '2023-02-01')
data
\dontshow{\}) # examplesIf}
}
