% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_longCallButterfly.R
\name{longCallbutterfly}
\alias{longCallbutterfly}
\title{Calculates per share Profit and Loss (PnL) at expiration for Long Call Butterfly Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
longCallbutterfly(
  ST,
  X,
  X1L,
  X3H,
  C,
  C1L,
  C3H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price for two ATM sold Calls.}

\item{X1L}{Lower Strike Price or eXercise price for one ITM long Call.}

\item{X3H}{Higher Strike Price or eXercise price for one OTM long Call.}

\item{C}{Call Premium or Call Price received for the two ATM sold Calls.}

\item{C1L}{Call Premium or Call Price paid for the first ITM long Call.}

\item{C3H}{Call Premium or Call Price paid for the one OTM long Call.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss column of the data frame}

\item{myData}{Data frame}

\item{myTibble}{Tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This is a volatility strategy consisting of a long position in an ITM (in the money) call option with a strike price $X1L, short positions in two ATM ( at the money) call options with a strike price $X, and a long position in an OTM (out of the money) call option with a strike price $X3H. The strikes are equidistant: $X3H minus $X equals to $X minus $X1L (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Long Call Butterfly Option Strategy and draw its graph in the Plots tab.
}
\examples{
longCallbutterfly(100,100,80,120,8,24,1,hl=0.55,hu=1.45)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865 \cr
R Graphics Cookbook. (n.d.). Coloring Negative and Positive Bars Differently. https://r-graphics.org/recipe-bar-graph-color-neg \cr
Gross C, Ottolinger P (2016).\emph{ggThemeAssist: Add-in to Customize 'ggplot2' Themes}. R package version 0.1.5, <URL: https://CRAN.R-project.org/package=ggThemeAssist>.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
