## Copyright 2021 Google LLC
##
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
##
##     https://www.apache.org/licenses/LICENSE-2.0
##
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
##
test_that("the factory works", {

  library(bsynth)
  ci_width <- 0.95
  data(gsynth, package = "gsynth")
  dplyr::glimpse(simdata)

  outcome_data <- simdata %>%
    dplyr::select(time, id, D, Y)

  covariates <- simdata %>%
    dplyr::select(time, id, X1, X2)

  synth <-
    bsynth::bayesianSynth$new(
      data = outcome_data,
      time = time,
      id = id,
      treated = D,
      outcome = Y,
      ci_width = ci_width,
      covariates = covariates
    )

  expect_type(synth, "environment")
})
