% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_leg.R
\name{two_leg}
\alias{two_leg}
\title{Create a two-leg stage or bracket}
\usage{
two_leg(participants, ...)
}
\arguments{
\item{participants}{Participants, a spec object, or a tournament object.}

\item{...}{Additional arguments forwarded to \code{two_leg_knockout()}.}
}
\value{
A bracket, spec, or tournament depending on \code{participants}.
}
\description{
Alias for \code{two_leg_knockout()} used by the tournament stage-verb API.
}
\examples{
# Two-leg knockout (Champions League style)
teams <- paste("Club", sprintf("\%02d", 1:16))
trn <- tournament(teams) |>
  round_robin("groups", groups = 4) |>
  two_leg("knockouts", take = top_per_group(2))
}
