# creating a base64-encoded image is possible

    Code
      img_file_html
    Output
      <table width="100%" align="center">
        <tr>
          <td align="center">
            <img src="data:image/png;base64,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" alt="" width="520" style="width:520px;"/>
          </td>
        </tr>
      </table>

---

    Code
      img_file_html2
    Output
      <table width="100%" align="center">
        <tr>
          <td align="center">
            <img src="data:image/png;base64,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" alt="A test image" width="520" style="width:520px;"/>
          </td>
        </tr>
      </table>

---

    Code
      img_file_html3
    Output
      <img src="data:image/png;base64,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" alt="A test image" width="520" style="width:520px;"/>

---

    Code
      img_file_html4
    Output
      <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIUAAABkCAYAAACowvMbAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KTMInWQAAGFRJREFUeAHtnbuPJFlWxk+8s7Kqumd2FnZ2jF2xDjhgIiQQEgb/AqwwENgI4SGEvQYGFgIDLLQSEj4GEmJwEFoLIUyENEgM7Aw7M/2qqnzEk993I29VZFZmRFZVdk93VtzurHjde+55fPfcc09GRgQff/xxYw8qIa1rR6EOEwuf/bXVz39oZXJmUb2wsNH13aW0wGI+VQMbYWCNRTYpr+zfn/6C/clHf2Sv4m+sNQ7uyG1Ig/CrH1l++acWwmcTRPSxhK+Yo9CipuV9rZPuQVQg3sTCurEyLe03/un79rt/9ztWxZXV4UBb6IjfJkA0ZGwst8oyi4PU7PIfbPnszyypoK96AZXuUeIqtB9+5zv2t09/AK0pPEXIVdGfFKW/US/VBr2jdleWcW3TV7nFs9mst9E+F71AdVhatFhYvSitLNmvMXkQ95KoYapAIWKOyk6UgLZ5VtpyWVlVLNcUJuX6ojZSeF9pZIy8sGpRQEfqqjlTur/GUdXXmGuSKWhKQFFj0sLyUp+la9lg8cpxvJtIRG+qEwcyEHxgqJLqEXIVfGo/Zpz468I4newm7a6cogBxUaNr1ddWg/QGrjd720hJfzWyGbrRxprC4jD0XG1rMnxOBK+ZVw+MQOnJjX8HiKyXiFDaqgLzaLQ0CRs+pk9sgNedFhGBb91TqH6/0AYPQS1KESCFBiNJSIowjtNB2/lOHkP4aZy3Y0StOG1QoAPEHp5CoKdTZyZM5v7Je9XQwF1Z6Yepk2+TjdVg2TzdOW4qwVySyA6tDgUSgVFnWwh2GmzsykO3cmlLYQDEDiUbFe9yGCCgjNUIEDIan5BppMZNh5iiRiF9pcGoLVNte4g4gQLXHloyhB9FbFXQ5XXB3oPFT2HBihfRhlMHDimzrwQAQhy1Rd6mlVdGbWBEgBsuApFGdPvP9QkY1DSEF1+8x/XH2tKstzTyZKuR4rbiz8kmvQ6XlSZaHVNdPMTbGBkmdVNDRlXRgBDAZDBt5YqYhhG8nTNvWmzsSbkAynkbtmojxNdNzhYiEScoUqcvFYpa6WFw+pB+mHZda3Gq8dCaRkREZ0B1Ac5fgJeAas+24ly7z7WB6VHUNX0odnEyQKoFQ6u3QAJTnB1WfbgTd/wjvKu50z86be2qzvqnb4nmvK3a8C/kRHzt+u/IhK9+M/20XoIeYEhCCrEoo+MefZvutnHSyDgoiXbyLwGSxaIhCXe155J4d0J1CW7uq71GKVtXH5oBjcRbC5D+qILWThYxJ0XrEzUEc5JPHqe17Wav18eujWi4cdv2pXOEuC093x5ZdP4+xQ0qT8f1AxXp0+lnH5rtqBGo5F8O4CmkNHUMxVVxc5vcsvMC/UjVjKjVRzuztYbDgsiDAdh2pzen4FU32jgj+053bLVqCPA87YhkNLjIrvUVDfPnUGmcV2hpiBfv1TRt6N/QoJJHcwBERY5ndQg2HO+yQgf0uu6BMUTX812jJ+FB3qcRT9qKrvOA8lPXaPFN1rYCQeiQrSlOl2SPA5R1AVrXJQcQCKnX4fWOjqjYgloKklpYMoo7AlbnPByjK2XpMqWNQdhBA3LKfUVBnebNim1MS23pgK4U9tFeeusr1Nc/BwH6k9FC9Qvf7UTUT8ABmfZtXcGjpeG8DJ7G6+6uYPAsO/rw47TittKg4hQPBr/1LTa2AoRUiJyOB6enjTqHOJSgLp6QcQf8q0IGZ3d0q6he/xTAucWiRpEfSR3bDwGhK4Oif9HXiKqg79btGFTHmrrctNVtcGvfMSadOaW1sokZgYohD43+IqMAcNWTBxQhyYj30sh2hPsJ9F7VsAiZzkJyL2anro86XDLFseoLcs7186dx2MoG9CsBpJ3oejsdLz4+DfTD6PHpY5QYDYygGGFwSwMjKG6pZDwxgmLEwC0NjKC4pZLxxAiKEQO3NPAaQMHaX+lfrX9vdXf7hFvxryqqTR9DjuZqXX2b0us/s5lo2qdHyadMhXhX8dv26OF/lW/h60f+JXwlzxfzZPyUtygjchQuq7lHHz6XtFJwnw32oDZWOUYNjKA4Rqs+UKYRFA9U4DE2H0FxjFZ9oEwjKB6owGNsPoLiGK36QJlGUDxQgcfY/CCgYKn8oOJvMOkS8eeUG/D5ge71u+536amtP96XjufBt/PHD2nvae1LY2s9cgxL3SvFHWIR92Pq5xK19quUWyOUIRku7r4Oqrk7Kcb7KYYV9hhrHMRTPEbFHbPMIyiO2br3lG0ExT0Vd8zNRlAcs3XvKdsIinsq7pibjaA4ZuveU7aDgOIh9wi4FMfq95TKd/j1v35I5L7eZ93t1/PuuurcIy9yTXf1gxl/fFe9+Xaep6H2vp7/cXPbvv3B1FDbfa7rF28BD0kIa+5hCclPOGPoJ4k5+tvTvD6fQVv9mmXPVvuwN9Y5Fg2MoDgWSx5QjhEUB1TmsZAaQXEsljygHCMoDqjMYyE1guJYLHlAOUZQHFCZx0LqAKDQMxdW6nBrZP8dPqT3XSfT3K//3QPDdA+F7gtwT9N491Ut2bx8Pm9xKKkantDXWMrDV/S8i4jnkcoY7Dec21N//kFv7iExZCkOAIpDiTfSeVs0MILibbHEa+Djvl5pBMVrMMbXQdIDwG8fwsMIiodo7y1u+xBwjKB4iw27D2sPMf4u+iModmnmHTx/KICMoHgHjf+6WT4AKLg3YPXshZuEhXIVfPz39H1SrHIZDuWdfa3rV7c+XLdWP/5zfXJwpyPidULFN/I5FX98+G0rh+4JaWm3+YqWJ5+7eEiv0ofeERDUeqannk2xoib9yQb7FG+nlXI7Gtun9VjnMWhgBMVjsPIdZRxBcUeFPYbqIygeg5XvKOMIijsq7DFUH0HxGKx8RxlHUNxRYY+h+kFAsb78F8n9ybpnKKze6eHeXbHSepud8zdqPMQUnbU663DlBm7yA8N8atmvNx5KRr0wJmZHXOXQ2oc71VEvXkd+y6m3tgxr5a1lfWTsdWlgBMUemj3Udwp7dPVWVBlBsacZHhMwRlDsCQpf7SYe4asG/4WGv3gk2xEU9zBkFxj3aP7WNxlBMWCiYwfANvFHUGzTyiM/x7K7s46/hzLCMLao5FmOUc2zEfRLg8LKmDcG8yOCmt8kGO+e6CvumY+0D/ndwmUW2PkiYf0/ce+sMN6TXutdmypa8G9JDES831Nl1/o/1EtvY3IKvAN0McktK1Lei5Hw6ubcluQa0oH39WZlYEvyKE18Yk3Z2IJh1Ewqm5Yzy2Nk4/cVfSVuEgvLkPdvkOcQHyVv5YiRMUzshPtHcp55+ZDYRK/BneQnNosyew9V6C3LWTPhHawJtpiz7X8fsd4Lq3e36rkWk4oWUYVuUFpfwda9pZbR9epowKH3dzeVXgCD0LWMixUDvUR1d8H8lqe0RfnpcoHSZiitQBjIhqmlunmkpwT8AMaXbcCAHQMFmJ6Xt+rGE/gNUFiYo4RYRtmCNE+QbRrOAc8rC1HYaZTYEwxcLWKbJeeWuNcf64WwuwutLeLF7QJFAqAyZNKbkxfNjFcNX8JP1uppN4neK7Pwivf5XlkWLCyOM1vUJVCQjBPkzUi29b+6W3qGCQYVuuETwmc8mfRbXS/Z7SsJHiGueCNNxIvTMTAgxZqMLFmITmSOvpIjRIRhpjTME7NJxpNZQHsqJuPcZgNIx85rRdJ0R16YXlh4CdhSvAKjAPGxToJR8WQJb9VZPUVnjUjn4GX8hF9dFSh4jg/Eqni/iYAOGKMqh9oNKDvNrncnus7tUHM8hFMH3sYy2jJokuYEVYljGeRG0T6O0Tm/f01wY2eaPLFiObHlVW054yeKUujm/EbsgufbXNmknm60WD+seIsTwsACduQty4tFafHf//PL9VobR+iut5TAP2IUFUKYEPHlJfpDWSjReYlaKNld8qy08zy000VjV+ST6xD3CurLs9J+9kuz+UDUo8f4XBf/CuzrE7IdU9uLE/vkJ3pwT6GnFVscAV/xLOEAZV/R6DljOMUAPWeq+hR8/NsvnbuX2Nf5HLDdGHMbnVADBGUXgTwCUyyjt05TW/5XZtVX4AUP6wCxAW5Ha9u5jU7KemGLD0/t1375WxaXp3jAgmlpahVerE4m/HKznz95Wk31uqUvDEN7/ryw+M//5mSjm/VD517WT60d6QXzCegvIRgTCwRfIrSzZOaUsVZ5y4Hce8JIrBFimUbYCAOA3t8KT+wPn76PS+wYfUt77ynaqWN9xKn6PPzIPokW9leffdN+UueAF+BVzOdSGvvJwPQpMGgqrDFehdf5l98M7F9/PwNeuP8akA14wirCKABRb/qKghKdLJjzQ5v/Y2GvPr206fx0zUuIZ3kH7zmGPEX6cmm/+t3Mfu/7H9j7Dd6hvLBkkli+4Bei2GbQfsinIjbV56efPkPnE+banjIwu1guD6EZghEdK+iapLhGvXydkQBTGml9JQrOLatKK6kfJ6AWxL7Cpc5x099MLu2iXgWaO4msPJHvhq2E8w7uw+WVvXia2hVSF9BNUjxbEdgpYAh5+Vq9ull4F/mGoFmzR1VN7PQlsQ5anj0FqM+XjHgePNbvaKBfYGQNmIr9hS3jmTH1Ez6nFj6fWo2+NKN5EIgPN8Wtzrn9Xcxx/sWUqYMHtT8tn+GYX8ArnrY4txLva2nGbHfR0xq58GIOhAQT4mH26sLiFNfRVwZ0hmhMkRKAuTllJDYlCmuWCEaAxWcokC1oGzIyFAETZdqEwAjPjtuL7QtAklZYpK9suH+arpVL4gcFkyWWyAq8F0bS6FnQ3xVzycnA6iHKLxywZxM8GQqPWRFF+RWsFrbMMHTd72lTAltNH2HIioBRKTlnKDXBrRfp1JKIaZbiQeEM1JGgHcedExu77xPexPnSqpIpNzllhUMfJUAOOcdqp2K11VcqTc/wU6OjlGm1DFiPFSyN+srAQIcIgSGjmqCcgsuAcCOanJfLZS3XR57VSmH5hHkVAkE9twWufs5UlJWp/fTszJ4zUvtKIN/cKVJidxWilUxOQKhb32MC2BKvxPrBBceneDkmk07r27t59A3qM0kUCzvBLUbL2BYVczbyvndxaYu0f3qL0cmSaca9KhIezlg6RoCjQtZGq4/y5BoQ6t3xrwGifQw1VF7geWxyRi8Tuygq+NKSsrApU3E5p19WWH0lQSdaFDj9aLXHwIyjAU+hEKSvTIkw9Q7MGGJZTQBFZVhjBCagtOIaRnPrWtw2QVYFCBRITmIQzNJOnqjh3RSKlqWRInhq50tyACj7MvuKwPCp6747z0pZMrzW5KGkgYgEawgEI40OVkOaw+nYpnKjGEIRZsU8F+VPbHb+EoAQ/IGHULmULWU11bJ2nwNSxRSpzTMCS3Ip+DKmuktWRixtuwjcQmdGIHyOLkr6X7K8DsspbXHreIrpgpxJRv8bxg9WwWGDbSSr5PQA8Vt1JZ0Qp3O9VHYIg0JL6pDukb0MtV7qt58Rv6kfeU95bZjT0O4vkcL1npIzEgsME6GgCNdTRTCDIIXmUhQesaQM2S9xaSUjNtJinTp5AcMwFCkBhAVSPIUMXMWlW6YFxBgWnjvjO0C4XEirIMI1jI4UkHLTjo7wTDpVAwyNSkXSqiNlNWiuYhmpFZFukomWmtqmFhCdR8tWPg8CLypcudKwxAsrEkKAKCiRxckJMDgXY7wSg/WVOCKxBE8Vms4ELubGBUBbRASpBGwa4yoO6CsP0aUn2VX8oPDHOucB4kEjmTUgdKx6MYNAx32lS9fXR0cD0weur68oi6kVQ8Q0EcGAPE8phNczNwoLpoFyQWJFhkTTM+blRk+DBThAgnl63rouFBekJF7yhUUzAERs0pws8Ry0REB9IsAkgfVJiBW0TZnrpeiIPAmHzFpuqGA8KS20E9bwWQUIqgzjMA1o2eugkjOtUAmaKrtMGyiGQEbFBHNGpPIyKfFJRTywZBUTZf36IdkizMMLPTBIGvIlyRRwpWQcudAmjaiwUbzMDtzoqms87atIh9KBjCndqKi+jkvyIira7yter6qfslRWfcb5s742ROj9SIsb1uwajSzRcoxdEvHW9qFzzYq8azux7/3MR/aERBFDk7W+GJeXEIoRVve6abWieVfzP9RO8OvfTb5nyXsxaW+SR/KJFD8yJIiCogVg+9/P/s/yHI+Ee28VJ29BogjAafrIiEm+LF7ZWXiGAj8AtIGdCCzwQkxGmxuDbHoL9VmWzP1kNTXSqzP4vERf//kfAF8JIozbrx7ntWIFm/KCTLFKOzd4x+rHr4gpyCtUxAQU8a6Pigzri4yuomsyvB8YOid9yIhLPN8nn3zi2sm4Xk+qM1RanbXg0kD7/PPPGVi/+NstJztayxX3FiWPtC5D2KB6gha/wqt/gfIxJiP4g7Ol/eUP/th+5ed/ziVUAlLFSvqETAdyzVrvuTU8hlRms8TFFkwzGa76/fqn7GV84UaaeKjkgaij4FfZtxfPn9sf/Ppf2NUlIKNdK6DE0UejC8pLXCrLvi/iT23CsissM1YijHwAWTFyEyLGbWDwYv93+CO7LP5HSLNkPiOpdmqzySmxyaWbSuRJ+krF9UDv9gI9ASiMiXEivI6RT8hmrwirzq6bewMJFB4Y3sACR5axguLTLbo+m82cXjRIBBqd09bFVuz3FfWp4tsJYMRb/etYcNtHE/2zJFPaV3O2rJUwEqJvM5IwPpHLVfzMnn7r2zY9PbWXl1cohK+7ECzBQAtGWcKIV6Co5RozCN81EAGTO1nieX5cfcaIbjN+MlxNoBYBBnUT0r68uLBFltsFSgkVg+iaWy61o8tNJ+A0YLSfk66OAFpB7JICGNZweBty/S7Shfam7lpdcYF+XEyAQd+bskRmJD7/CoDhKeABqPTqp0QSNIEH1NQB3wTmypPM6O/ybGrRvO3IG2eTmMAgI3uPIeP5uh5EOjef843HChB5TuCPBxEoPLg26fpj0dBH9PVxU4hhvAcVF0coVQrjEHfIJjitle1D3ppYI78CNDmrE+b9AgWXTA/wbzmjr1JEToBaE3BUpLgDEjxJwbyIgUPHaAtKl67F1g2jSOAO9U0jRk5QmOIVgUXgokc+rYUF0nhJ8Ess0ODCF5rXEVchqFYpylkUK1fdwmibJkj7slpqCDRnNFYSKklSvqfBEDSKdqxePKWINpUGCGAqmD4SvtuJM76fWJJ+n+mrgDaPIL15Y/u22uq8DOvBoXMeDH5fAPDtdU3TgACi4uzh9rb/8e18XbVnmPZ7gkDDt6c0Kd9qKjJXXCDzuEBPRlB0QOCCMchx4pIQBmAQsvMfcKCkiPhD8ULIyFHqt2bktqsEjU6MyScl/mCMyQnwF0Rj2AawNIBIXkEA8XGBAssaoKmuSkAdLYkDvuNQ3Yh2tNL9+czrfJ1NHkVLUxX9bcesO7z+UzHdKdWdaFrDa6xWi6w+ADPB4kAWnu8jxANqxrhn0gGBtpJ7lWIMprUYXrpl04geKN2tACKgqK4+BSs5XfdA0L7ObdLq9uP3VVf1fHt5F7jdPUbUUM+z7C1E9SruvgzFF+4AFQeaVliJ4DUiBaAYo46mKF8BGr2GrNX58kbrdYY8o4iTziqt51I2wAWCggRWVsY0wxtVbGsCNYW2oQyqOVtfxAEqBYRuKYt30rsvNLpd1I8xRVrv3XTSrpyj7iXYdj+Jq7uSWxsl5hwY8H6NvCBTlRQZ4/F87CGxt5UikbQAiL+FPJlLJnGMYVMcqIDuizdQ15ja9yDw9fyUoPoq3qBdb+Lr+DZ92y4d9SdexzJqYE0DIyjW1DEeSAMjKEYc3NLACIpbKhlPjKAYMXBLAyMobqlkPDGCYsTALQ18baDQeri7Hr/F2Z4n2rW9xGjzKZ6m7q1QnmSo3GQJqL46cCkTcgC3Ut9DxB54XbxLnlamVp4HkrxX868NFPfidmz0RjQwguKNqPnd6mQExbtlrzfC7QiKN6Lmd6uTERTvlr3eCLcjKN6Imt+tTkZQvFv2eiPcHhwUPk/Qcr87F+HX44NScm+Eq8uyXb8nCdxd29w0w70JupWuXdsrH3Fzb4Fo6gab9k6swR62VliXY2uVg5/0+Qmfrzh4B3sSPBwoOjd8uL5Xx7v4kOD+062zea57rH0Vv+22u+++DNEtHqyb57t1jn2fO68OVFYG26S2rmSfsWvvOPKZw10GcG3dvUk3t4y1LdcNudnnXY43AeaPD9fDXbh5O+rGXgm72NlHOdsSsmqn87pv0P3AhJtLdSspdxK6H//oHkv9sFj3uXngiAfxo48/p1+Y3ZznOvdV6mduouvvSXQV7vnH9bdq6+ToCrMD6Pfs6p1p9v8LgbV0bcMorAAAAABJRU5ErkJggg==" alt="A test image" width="520" align="right" style="float:right;width:520px;"/>

