% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_group_trajectory_3d.R
\name{plot_group_trajectories_3d}
\alias{plot_group_trajectories_3d}
\title{Visualize 3D Technological Trajectories from Group Evolution}
\usage{
plot_group_trajectories_3d(
  groups_cumulative_trajectories,
  group = "component1_g01",
  jaccard_similarity = 0.1,
  prop_tracked_intra_group_treshold = 0.2,
  label_type = "size",
  label_vertical_position = 0,
  label_horizontal_position = 0,
  label_angle = 0,
  time_span = NA,
  show_legend = TRUE,
  last_year_keywords = NULL
)
}
\arguments{
\item{groups_cumulative_trajectories}{A list containing two components:
\itemize{
\item groups_similarity: Similarity data between groups
\item groups_attributes: Attribute data for each group
}}

\item{group}{The specific group to visualize (default: "component1_g01")}

\item{jaccard_similarity}{Minimum Jaccard similarity threshold for connections (default: 0.1)}

\item{prop_tracked_intra_group_treshold}{Minimum proportion of tracked intra-group documents
for nodes to be included (default: 0.2)}

\item{label_type}{Type of labels to display on nodes ("size" for weighted size or "id" for group IDs)}

\item{label_vertical_position}{Vertical adjustment for node labels (default: 0)}

\item{label_horizontal_position}{Horizontal adjustment for node labels (default: 0)}

\item{label_angle}{Angle for node labels (default: 0)}

\item{time_span}{Optional vector specifying the time span to display (default: NA shows all years)}

\item{show_legend}{Logical indicating whether to show the color legend (default: TRUE)}

\item{last_year_keywords}{Optional keywords description for the last year (default: NULL)}
}
\value{
A plotly 3D visualization object
}
\description{
Creates an interactive 3D visualization of technological trajectories showing the evolution
of research groups over time with node size representing group importance and color
representing publication year deviation.
}
\examples{
\dontrun{
# First get trajectory data
traj_data <- sniff_groups_trajectories(groups_cumulative)

# Visualize a specific group in 3D
plot_group_trajectory_3d(
  groups_cumulative_trajectories = traj_data,
  group = "component1_g05",
  jaccard_similarity = 0.2
)
}

}
