% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_audit.R
\name{plot_fold_balance}
\alias{plot_fold_balance}
\title{Plot fold balance of class counts per fold}
\usage{
plot_fold_balance(fit)
}
\arguments{
\item{fit}{LeakFit.}
}
\value{
A list containing the fold summary, positive class (if binomial),
  and a ggplot object.
}
\description{
Displays a bar chart of class counts per fold. For binomial tasks, it also
overlays the positive proportion to diagnose stratification issues. The
positive class is taken from \code{fit@info$positive_class} when available;
otherwise the second factor level is used. For multiclass tasks, the plot
shows per-class counts without a proportion line. Only available for
classification tasks. Requires ggplot2.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  set.seed(42)
  df <- data.frame(
    subject = rep(1:15, each = 2),
    outcome = factor(rep(c(0, 1), 15)),
    x1 = rnorm(30),
    x2 = rnorm(30)
  )
  splits <- make_split_plan(df, outcome = "outcome",
                            mode = "subject_grouped", group = "subject",
                            v = 3, progress = FALSE)
  custom <- list(
    glm = list(
      fit = function(x, y, task, weights, ...) {
        stats::glm(y ~ ., data = as.data.frame(x),
                   family = stats::binomial(), weights = weights)
      },
      predict = function(object, newdata, task, ...) {
        as.numeric(stats::predict(object, newdata = as.data.frame(newdata),
                                  type = "response"))
      }
    )
  )
  fit <- fit_resample(df, outcome = "outcome", splits = splits,
                      learner = "glm", custom_learners = custom,
                      metrics = "auc", refit = FALSE, seed = 1)
  plot_fold_balance(fit)
}

}
