% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{latent.heat.vaporization}
\alias{latent.heat.vaporization}
\title{Latent Heat of Vaporization}
\usage{
latent.heat.vaporization(Tair)
}
\arguments{
\item{Tair}{Air temperature (deg C)}
}
\value{
\eqn{\lambda} - Latent heat of vaporization (J kg-1)
}
\description{
Latent heat of vaporization as a function of air temperature.
}
\details{
The following formula is used:

  \deqn{\lambda = (2.501 - 0.00237*Tair)10^6}
}
\examples{
latent.heat.vaporization(seq(5,45,5))             
            
}
\references{
Stull, B., 1988: An Introduction to Boundary Layer Meteorology (p.641)
            Kluwer Academic Publishers, Dordrecht, Netherlands
            
            Foken, T, 2008: Micrometeorology. Springer, Berlin, Germany.
}
