% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack_bids.R
\name{list_pack_bids}
\alias{list_pack_bids}
\title{List Contents of Packed BIDS Archive}
\usage{
list_pack_bids(archive_path, verbose = TRUE)
}
\arguments{
\item{archive_path}{Character string specifying the path to the archive file.}

\item{verbose}{Logical. Whether to print summary statistics. Default is TRUE.}
}
\value{
A data frame with columns:
\item{file}{Relative file path within the archive}
\item{size}{File size in bytes}
\item{is_stub}{Logical indicating if the file is a 0-byte stub}
\item{is_downsampled}{Logical indicating if the file is a downsampled image}
\item{type}{File type based on extension (imaging, imaging_stub, imaging_downsampled, json, tsv, etc.)}
}
\description{
This function lists the contents of a BIDS archive created by \code{\link{pack_bids}},
showing file sizes and identifying which files are stubs.
}
\examples{
\donttest{
# Create and inspect a packed BIDS archive
tryCatch({
  ds_path <- get_example_bids_dataset("ds001") 
  proj <- bids_project(ds_path)
  archive_path <- pack_bids(proj, verbose = FALSE)
  
  # List contents
  contents <- list_pack_bids(archive_path)
  
  # Show stub files
  stub_files <- contents[contents$is_stub, ]
  print(head(stub_files))
  
  # Clean up
  unlink(archive_path)
  unlink(ds_path, recursive = TRUE)
}, error = function(e) {
  message("Example failed: ", e$message)
})
}

}
