% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.brsmm_loglik_laplace_cpp}
\alias{.brsmm_loglik_laplace_cpp}
\title{C++ log-likelihood for mixed beta interval regression (Laplace)}
\usage{
.brsmm_loglik_laplace_cpp(
  param,
  X,
  Z,
  y_left,
  y_right,
  yt,
  delta,
  group,
  link_mu_code,
  link_phi_code,
  repar
)
}
\arguments{
\item{param}{Parameter vector:
\code{beta (p), gamma (q), log_sigma_b (1)}.}

\item{X}{Mean-model design matrix.}

\item{Z}{Precision-model design matrix.}

\item{y_left}{Left interval endpoints.}

\item{y_right}{Right interval endpoints.}

\item{yt}{Midpoint responses.}

\item{delta}{Censoring indicator vector.}

\item{group}{Integer group index (1..G), one per observation.}

\item{link_mu_code}{Integer code for mean link.}

\item{link_phi_code}{Integer code for precision link.}

\item{repar}{Integer beta reparameterization code.}
}
\value{
Scalar marginal log-likelihood.
}
\description{
Computes the marginal log-likelihood for a random-intercept
  beta interval model using a Laplace approximation of group-specific
  integrals over Gaussian random effects.
}
\keyword{internal}
