% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{brs_bootstrap}
\alias{brs_bootstrap}
\alias{print.brs_bootstrap}
\title{Parametric bootstrap confidence intervals for brs models}
\usage{
brs_bootstrap(
  object,
  R = 199L,
  level = 0.95,
  ci_type = c("percentile", "basic", "normal", "bca"),
  max_tries = NULL,
  keep_draws = FALSE
)

\method{print}{brs_bootstrap}(x, ...)
}
\arguments{
\item{object}{A fitted \code{"brs"} object (fixed or variable dispersion).}

\item{R}{Integer: number of bootstrap replicates (default 199).}

\item{level}{Numeric: confidence level (default 0.95).}

\item{ci_type}{Character: type of confidence interval. One of
\code{"percentile"} (default), \code{"basic"}, \code{"normal"},
or \code{"bca"}.}

\item{max_tries}{Optional integer: maximum number of bootstrap attempts
to obtain converged replicates. If \code{NULL}, uses \code{max(3 * R, 50)}.}

\item{keep_draws}{Logical: if \code{TRUE}, stores successful bootstrap
parameter draws in attribute \code{"boot_draws"}.}

\item{x}{Object returned by \code{brs_bootstrap}.}

\item{...}{Ignored.}
}
\value{
A data frame with columns \code{parameter}, \code{estimate}
  (original point estimate), \code{se_boot} (bootstrap standard error),
  \code{ci_lower}, \code{ci_upper}, \code{mcse_lower}, \code{mcse_upper},
  \code{wald_lower}, \code{wald_upper}, and \code{level}. The attribute
  \code{"n_success"} gives the number of replicates that converged.
  Additional attributes include \code{"R"}, \code{"n_attempted"},
  \code{"ci_type"}, and optionally \code{"boot_draws"}.
}
\description{
Computes bootstrap-based confidence intervals for the parameters of a
fitted \code{"brs"} model by repeatedly simulating data from the fitted
model and re-estimating parameters. Only \code{"brs"} (fixed or
variable-dispersion) objects are supported; \code{"brsmm"} is not supported.
}
\details{
For each replicate, data are simulated via \code{\link{brs_sim}} using
the estimated coefficients (on the link scale) and the original
design. The model is then re-fitted with \code{\link{brs}}. Replicates
that fail to converge are discarded; if the number of successful replicates
is too low, a warning is issued. Intervals are the empirical quantiles of
the bootstrap distribution of each parameter.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(brs_bootstrap)}: Print method for bootstrap results

}}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
boot <- brs_bootstrap(fit, R = 50, level = 0.95)
print(boot)
}

}
\seealso{
\code{\link{confint.brs}} for Wald intervals;
  \code{\link{brs_sim}} for simulation; \code{\link{brs}} for fitting.
}
