% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{AIC.brs}
\alias{AIC.brs}
\title{Akaike information criterion}
\usage{
\method{AIC}{brs}(object, ..., k = 2)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{...}{Ignored.}

\item{k}{Penalty per parameter (default 2).}
}
\value{
Scalar AIC value.
}
\description{
Akaike information criterion
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
AIC(fit)
}

}
\seealso{
\code{\link{brs}}, \code{\link{logLik.brs}}, \code{\link{BIC.brs}},
  \code{\link{brs_gof}}
}
