% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_bertopic_model.R
\name{load_bertopic_model}
\alias{load_bertopic_model}
\title{Load a BERTopic Model Bundle}
\usage{
load_bertopic_model(path, embedding_model = NULL)
}
\arguments{
\item{path}{Directory path where the Python model was saved.}

\item{embedding_model}{Optional embedding model to pass through to
\code{BERTopic$load()} when the embedding model is not serialized.}
}
\value{
A list with two elements: \code{model} (the BERTopic model) and \code{extras}
(the R-side data saved in the companion RDS file).
}
\description{
Load a BERTopic model saved with \code{save_bertopic_model()} along with its
companion RDS file containing R-side extras.
}
\examples{
\donttest{
if (dir.exists("topic_model")) {
  loaded <- load_bertopic_model("topic_model")
  print(loaded$extras)
} else {
  message("No saved model found at 'topic_model'.")
}
}
}

