% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_network_insights_path}
\alias{ec2_create_network_insights_path}
\title{Create Network Insights Path}
\usage{
ec2_create_network_insights_path(
  Source,
  Destination,
  Protocol,
  ClientToken,
  SourceIp = NULL,
  DestinationIp = NULL,
  DestinationPort = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Source}{Character. The AWS resource that is the source of the path.}

\item{Destination}{Character. The AWS resource that is the destination of the path.}

\item{Protocol}{Character. The protocol.}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.}

\item{SourceIp}{Character. The IP address of the AWS resource that is the source of the path.[optional]}

\item{DestinationIp}{Character. The IP address of the AWS resource that is the destination of the path.[optional]}

\item{DestinationPort}{Integer. The destination port.[optional]}

\item{TagSpecification}{List. The tags to add to the path.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Network Insights Path
}
\section{Source}{

The AWS resource that is the
source of the path.
}

\section{Destination}{

The AWS resource that is the
destination of the path.
}

\section{Protocol}{

The
protocol.
}

\section{ClientToken}{

Unique, case-sensitive identifier that you
provide to ensure the idempotency of the request. For more information,
see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{How to Ensure Idempotency}.
}

\section{SourceIp}{

The
IP address of the AWS resource that is the source of the
path.
}

\section{DestinationIp}{

The IP address of the AWS resource that is the
destination of the path.
}

\section{DestinationPort}{

The destination
port.
}

\section{TagSpecification}{

The tags to add to the
path.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

