% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_functions.R
\name{correlation_analysis}
\alias{correlation_analysis}
\title{Correlation Analysis with Significance}
\usage{
correlation_analysis(
  data,
  method = "pearson",
  plot = TRUE,
  digits = 3,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame with numeric variables}

\item{method}{Correlation method: "pearson", "spearman", or "kendall"}

\item{plot}{Logical, whether to generate correlation plot}

\item{digits}{Number of decimal places}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List with correlation matrix and significance matrix
}
\description{
Computes correlation matrix with significance levels and generates
publication-ready correlation table and plot.
}
\examples{
data <- data.frame(
  yield = c(1200, 1350, 1100, 1450, 1280),
  wue = c(4.2, 4.8, 3.9, 5.1, 4.5),
  protein = c(22.1, 23.5, 21.8, 24.2, 22.9)
)
correlation_analysis(data)

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
