% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aridagri-package.R
\docType{package}
\name{aridagri-package}
\alias{aridagri-package}
\alias{aridagri}
\title{aridagri: Comprehensive Statistical Tools for Agricultural Research}
\description{
The aridagri package provides comprehensive statistical and analytical tools 
for agricultural research. It includes complete ANOVA functions for all 
experimental designs, multiple post-hoc tests, stability analysis methods,
thermal indices, crop growth analysis, and advanced statistical methods.
}
\section{Experimental Design ANOVA Functions}{

\itemize{
  \item \code{\link{anova_crd}}: Completely Randomized Design
  \item \code{\link{anova_rbd}}: Randomized Block Design
  \item \code{\link{anova_rbd_pooled}}: Pooled RBD (Multi-Environment)
  \item \code{\link{anova_latin}}: Latin Square Design
  \item \code{\link{anova_factorial}}: Two-Factor Factorial
  \item \code{\link{anova_factorial_3way}}: Three-Factor Factorial
  \item \code{\link{anova_spd}}: Split Plot Design
  \item \code{\link{anova_sspd}}: Split-Split Plot Design
  \item \code{\link{anova_strip}}: Strip Plot Design
  \item \code{\link{anova_augmented}}: Augmented Block Design
  \item \code{\link{anova_alpha_lattice}}: Alpha Lattice Design
}
}

\section{Post-Hoc Tests}{

\itemize{
  \item \code{\link{perform_posthoc}}: Multiple comparison tests (LSD, Duncan, Tukey, SNK, Scheffe, Bonferroni, Dunnett)
  \item \code{\link{check_assumptions}}: ANOVA assumption checking
}
}

\section{Agronomic Analysis Functions}{

\itemize{
  \item \code{\link{stability_analysis}}: Multi-method stability analysis (Eberhart-Russell, AMMI, Finlay-Wilkinson, Shukla, Wricke, CV, Superiority)
  \item \code{\link{thermal_indices}}: GDD, HTU, PTU, Heat Use Efficiency
  \item \code{\link{crop_growth_analysis}}: CGR, RGR, NAR, LAI
  \item \code{\link{harvest_index}}: Harvest index and partitioning
  \item \code{\link{yield_gap_analysis}}: Yield gap calculations
  \item \code{\link{economic_indices}}: B:C ratio, net returns
}
}

\section{Statistical Functions}{

\itemize{
  \item \code{\link{correlation_analysis}}: Correlation matrix with significance
  \item \code{\link{pca_analysis}}: Principal component analysis
  \item \code{\link{path_analysis}}: Path coefficient analysis
  \item \code{\link{sem_analysis}}: Structural equation modeling
}
}

\section{Nutrient Analysis Functions}{

\itemize{
  \item \code{\link{nue_calculate}}: Nutrient use efficiency calculations
  \item \code{\link{nutrient_response}}: Response curve analysis
  \item \code{\link{economic_analysis}}: Economic viability assessment
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/lalitrolaniya/aridagri}
  \item Report bugs at \url{https://github.com/lalitrolaniya/aridagri/issues}
}

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
\keyword{package}
