% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_split_plot.R
\name{anova_spd_pooled}
\alias{anova_spd_pooled}
\title{Pooled Split Plot Design Analysis}
\usage{
anova_spd_pooled(
  data,
  response,
  main_plot,
  sub_plot,
  environment,
  replication,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing combined data}

\item{response}{Name of the response variable}

\item{main_plot}{Name of main plot factor}

\item{sub_plot}{Name of sub-plot factor}

\item{environment}{Name of environment factor}

\item{replication}{Name of replication factor (nested within environment)}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing pooled ANOVA and component analyses
}
\description{
Performs pooled analysis of Split Plot Design experiments conducted 
across multiple environments/years/locations.
}
\examples{
data <- expand.grid(
  year = c("Y1", "Y2", "Y3"),
  rep = 1:3,
  irrigation = c("I1", "I2", "I3"),
  variety = c("V1", "V2", "V3", "V4")
)
data$yield <- rnorm(nrow(data), 1200, 180)

anova_spd_pooled(data, response = "yield", main_plot = "irrigation",
                 sub_plot = "variety", environment = "year", replication = "rep")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
