% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_basic.R
\name{anova_crd}
\alias{anova_crd}
\title{============================================================================
COMPREHENSIVE EXPERIMENTAL DESIGN ANALYSIS FUNCTIONS
Package: aridagri
Author: Lalit Kumar Rolaniya
ICAR-Indian Institute of Pulses Research, Regional Centre, Bikaner
============================================================================
Completely Randomized Design (CRD) ANOVA}
\usage{
anova_crd(
  data,
  response,
  treatment,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable (as string)}

\item{treatment}{Name of treatment factor}

\item{posthoc}{Post-hoc test: "lsd", "duncan", "tukey", "snk", "scheffe", or "all"}

\item{alpha}{Significance level (default 0.05)}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA table, means, post-hoc results, and diagnostics
}
\description{
Performs complete ANOVA for Completely Randomized Design with post-hoc tests,
assumptions checking, and publication-ready output.
}
\examples{
data <- data.frame(
  treatment = rep(c("T1", "T2", "T3", "T4"), each = 5),
  yield = c(rnorm(5, 1200, 50), rnorm(5, 1350, 60), 
            rnorm(5, 1100, 55), rnorm(5, 1450, 65))
)
anova_crd(data, response = "yield", treatment = "treatment", posthoc = "all")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
