% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nutrient_use_efficiency.R
\name{ner}
\alias{ner}
\title{Nutrient Efficiency Ratio (NER)}
\usage{
ner(ibw, fbw, fi, nut_f, dm = 1)
}
\arguments{
\item{ibw}{a numeric value for the initial weight (either average
weight of the individuals or the total biomass) of the livestock at the
beginning of the feeding trial.}

\item{fbw}{a numeric value for the final weight (either average
weight of the individuals or the total biomass) of the livestock at the end
of the feeding trial.}

\item{fi}{numeric; value providing the total feed intake in grams during the
experiment.}

\item{nut_f}{numeric; value within the interval of (0,1), indicating the
inclusion rate of the nutrient of interest in the feed fed.}

\item{dm}{numeric; value within the interval of (0,1), indicating the dry 
matter content of the feed. Default is 1 (100\%).}
}
\value{
returns a single numeric value
}
\description{
Function to calculate the Nutrient Efficiency Ratio (NER). The NER belongs 
to the Nutrient Use Efficiency metrics and relates the intake of a compound 
with the bodyweight increase. If the feed intake (FI) is restricted and the 
administered diets are of comparable digestibility, then potential 
differences in growth could be related to differences in the sub-composition 
of target nutrients that are also controlled for. This would be reflected by 
the NER.
}
\examples{
# Initial bodyweight = 10 g
# Final bodyweight = 100 g
# Feed intake = 240 g
# Nutrient mass fraction in feed = 0.5 g/g
ner(ibw = 10, fbw = 100, fi = 240, nut_f = 0.5)

}
\author{
Anıl Axel Tellbüscher
}
