% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_plot.lm.R
\name{sl_plot.lm}
\alias{sl_plot.lm}
\title{Spread-level plot for \code{lm} object}
\usage{
\method{sl_plot}{lm}(
  model,
  rtype = c("standardized", "studentized", "internally studentized",
    "externally studentized"),
  xaxis = "fitted",
  id_n = 3,
  predictors = ~.,
  smooth = stats::loess,
  add_smooth = TRUE,
  ...,
  text_arglist = list(),
  smooth_arglist = list(),
  lines_arglist = list()
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{rtype}{The residual type to plot. The default is
\code{"ordinary"}. The other options are
\code{"standardized"}, \code{"studentized"},
\code{"loo"}, \code{"jackknife"}, \code{"deleted"},
\code{"internally studentized"}, \code{"externally
studentized"}.}

\item{xaxis}{The variable to use on the x-axis of the
plot(s). The default is \code{"fitted"} to use fitted
values. The other option is \code{"predictors"}.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{predictors}{A formula describing the first-order
predictors to plot the residuals against. The default
is all available first-order predictors.}

\item{smooth}{A function with a
\code{\link[stats]{formula}} argument to smooth the
desired plot. The default function is
\code{\link[stats]{loess}.}}

\item{add_smooth}{A logical value indicating whether a
smooth should be added to each plot produced. The
default is \code{TRUE}.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{smooth_arglist}{A named list specifying additional
arguments passed to the function provided in the
\code{smooth} argument.}

\item{lines_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{lines}}
function for plotting the result of applying the
\code{smooth} function.}
}
\description{
\code{sl_plot.lm} plots a spread-level plot of a fitted
\code{lm} object. In general, it is intended to provide
similar functionality to \code{\link[stats]{plot.lm}}
when \code{which = 3}, but can be used for different
types of residuals and can also plot first-order
predictor variables along the x-axis instead of only the
fitted values.\cr\cr Details about the different types of
residuals are discussed in the
\code{\link[api2lm]{get_residuals}} function.
}
\examples{
lmod <- lm(Petal.Length ~ Sepal.Length + Species,
           data = iris)
# similarity with built-in plot.lm functionality
sl_plot(lmod)
plot(lmod, which = 3)
# spread-level plot for other residual types
sl_plot(lmod, rtype = "studentized", id_n = 0)
# spread-level plot for predictors
sl_plot(lmod, xaxis = "pred", id_n = 2)
# spread-level plot for individual predictors
sl_plot(lmod, xaxis = "pred",
        predictors = ~ Sepal.Length,
        id_n = 2)
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[graphics]{lines}}
  \code{\link[stats]{loess}}.
}
\author{
Joshua French
}
