% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfbeta_plot.R
\name{dfbeta_plot}
\alias{dfbeta_plot}
\title{dfbeta index plots}
\usage{
dfbeta_plot(
  model,
  id_n = 3,
  regressors = ~.,
  add_reference = TRUE,
  ...,
  text_arglist = list(),
  abline_arglist = list(),
  extendrange_f = 0.08
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{regressors}{A formula describing the regressors for
which to plot the \code{dfbetas} statistics. The
default is all available regressors.}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
\code{dfbeta_plot} creates an index plot of the
\code{dfbeta} statistics for each regressor.
}
\details{
A horizontal reference line is added at +/- the
estimated standard error of each coefficient by
default if \code{add_reference} is \code{TRUE}.
}
\examples{
lmod <- lm(murder ~ hs_grad + urban + poverty + single,
           data = crime2009)
dfbeta_plot(lmod)
dfbeta_plot(lmod, regressors = ~ hs_grad + poverty,
            id_n = 1)
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[graphics]{abline}}
  \code{\link[stats]{dfbeta}}.
}
\author{
Joshua French
}
