#' Home sale prices in King County, WA
#'
#' The \code{home_sales} data set is a data frame consisting of
#' 216 rows and 8 columns. The data are a subset of home
#' sales in King County, WA made between 2014-05-02 to
#' 2015-05-27. The variables in the data set are:
#' \itemize{
#' \item \code{price}: sale price (in log10 US dollars).
#' \item \code{bedrooms}: number of bedrooms.
#' \item \code{bathrooms}: number of bathrooms.
#' \item \code{sqft_living}: size of living space in square feet.
#' \item \code{sqft_lot}: lot size in square feet.
#' \item \code{floors}: number of floors in home.
#' \item \code{waterfront}: a \code{factor} variable with levels \code{no} and `yes`
#' that indicate whether the home has a waterfront view.
#' \item \code{condition}: a \code{factor} variable indicating the condition of the house with levels
#' ranging from \code{poor} to \code{very good}.
#' }
#'
#' @name home_sales
#' @docType data
#' @return A \code{data.frame}.
#' @keywords datasets
#' @source The Center for Spatial Data Science, University
#' of Chicago.
#' \url{https://geodacenter.github.io/data-and-lab//KingCounty-HouseSales2015/}
#'
#' These data were created by selectively choosing a subset
#' of observations from the \code{home_prices} data set in the
#' **KingCountyHomes** package.
#'
#' @examples
#' data(home_sales)
#' summary(home_sales)
NULL