% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normAnalyzer.R
\name{norm_test_fun}
\alias{norm_test_fun}
\title{Checks for Normality Assumption}
\usage{
norm_test_fun(x, method = "anderson", pval = 0.05, xn = "x", bin = FALSE)
}
\arguments{
\item{x}{a numeric vector}

\item{method}{\code{shapiro} for Shapiro-Wilk test or
\code{'anderson'} for 'Anderson-Darling' test of normality or \code{ks} for
'Kolmogorov-Smirnov'}

\item{pval}{significance level for normality tests. Default is 0.05}

\item{xn}{vector name}

\item{bin}{TRUE if only TRUE/FALSE is required}
}
\value{
Logical TRUE/FALSE based on the performed test and \code{pval}.
If the vector follows the normality assumption, then TRUE is returned
}
\description{
\code{norm_test_fun} checks for the normality assumption
}
\details{
This function checks for normality assumption using
shapiro, Kolmogorov-Smirnov  or Anderson Darling test.
If the parameter \code{bin} is TRUE, then \code{TRUE} is returned
if vector is normal, otherwise FALSE.
The significance level is passed through the parameter
\code{pval}
}
\examples{
norm_test_fun(mtcars$mpg)
norm_test_fun(mtcars$mpg, method = "shapiro",
              pval = 0.05, xn = "mpg", bin = TRUE)

}
\seealso{
\code{\link{anderson.test}} for Anderson Darling test
}
